unit Sensor01;

//       
//    ().

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

// ================================================================
//      ()
type TSensor = class(TObject)
private
  // ---------------
  fPanel     : TPanel;       //    
  // ---------------
  fLbIndx    : TLabel;       //   
  fLbTitle   : TLabel;       //   
  fSTxtIndx  : TStaticText;  //  
  fEdTitle   : TEdit;        //  
  // ---------------
  fLbMin     : TLabel;       //    
  fLbValue   : TLabel;       //    
  fLbMax     : TLabel;       //    
  fEdMin     : TEdit;        //   
  fSTxtValue : TStaticText;  //   
  fEdMax     : TEdit;        //   
  // ---------------
  fTrackBar : TTrackBar;     //   
  // ---------------
  fChBoxNPr : TCheckBox;     //   
  fEdNPr    : TEdit;         //   
  // ---------------
  //    
  procedure EdMinChange(Sender: TObject);
  procedure EdMaxChange(Sender: TObject);
  procedure TrackBarChange(Sender: TObject);
  // ---------------------
  //  
  // ---------------------
  procedure SetIndx(Indx : integer);
  function  GetIndx() : integer;
   // ---------------------
  procedure SetTitle(Title : string);
  function  GetTitle() : string;
  // ---------------------
  procedure SetMin(Min : integer);
  function  GetMin() : integer;
  // ---------------------
  procedure SetMax(Max : integer);
  function  GetMax() : integer;
   // ---------------------
  function  GetValue() : integer;

public
   constructor Create(RqWinControl : TWinControl; XB,YB : integer);
   procedure Free;
   property Indx  : integer read GetIndx  write SetIndx;
   property Title : string  read GetTitle write SetTitle;
   property Min   : integer read GetMin   write SetMin;
   property Max   : integer read GetMax   write SetMax;
   property Value : integer read GetValue;
end;

// ================================================================
// ================================================================

implementation

// ================================================================
// ================================================================

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
//  RqEdit.Text     
function TryEditToInt(RqEdit : TEdit; var Value : integer) : boolean;
begin
   Result := False;
   try
       if Trim(RqEdit.Text) = ''
       then Value := 0
       else begin
           Value := StrToInt(Trim(RqEdit.Text));
           RqEdit.Color := clWindow;
       end;
       Result := True;
   except
       RqEdit.Color := RGB(255,240,240);
       ShowMessage('       ');
   end;
end;

// ----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (,  Form1).

function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;               //    
      Name := ComponentName;           //   
      SetBounds(X, Y, W, H);           //   TWinControl
      Visible := True;                 //   
    end;
end;

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//   
constructor TSensor.Create(
          RqWinControl : TWinControl;  //      
          XB, YB : integer);           // Left  Top  
begin
   inherited Create;
   // ----------------------------------------------
   //      
   fPanel:= TPanel(CreateControl(TPanel, RqWinControl, '',
                   XB,YB,240,150));
   // ----------------------------------------------
   //       
   // ----------------------------------------------
   //  
   fLbIndx := TLabel(CreateControl(TLabel, fPanel, '',
                       12,8,40,20));
   fLbIndx.Caption := '';
   fSTxtIndx := TStaticText(CreateControl(TStaticText, fPanel, '',
                       12, 26, 40, 20));
   fSTxtIndx.Alignment   := taCenter;
   fSTxtIndx.AutoSize    := False;
   fSTxtIndx.BorderStyle := sbsSunken;
   fSTxtIndx.Font.Style  := [fsBold];
   // ----------------------------------------------
   //  
   fLbTitle := TLabel(CreateControl(TLabel, fPanel, '',
                       56,8,40,20));
   fLbTitle.Caption := ' ';
   fEdTitle := TEdit(CreateControl(TEdit, fPanel, '',
                       56, 26, 170, 20));
   // ----------------------------------------------
   //  
   fEdMin  := TEdit(CreateControl(TEdit, fPanel, '',
                       12,66,70,20));
   fEdMin.Text := '-100';
   fEdMin.OnChange := EdMinChange;
   fLbMin := TLabel(CreateControl(TLabel, fPanel, '',
                       12,48,70,20));
   fLbMin.Caption := 'Min';
   // ----------------------------------------------
   //  
   fSTxtValue := TStaticText(CreateControl(TStaticText, fPanel, '',
                        84,66,70,20));
   fSTxtValue.Alignment   := taCenter;
   fSTxtValue.AutoSize    := False;
   fSTxtValue.BorderStyle := sbsSunken;
   fSTxtValue.Font.Style  := [fsBold];
   fSTxtValue.Caption := '0';
   fLbValue := TLabel(CreateControl(TLabel, fPanel, '',
                       84,48,70,20));
   fLbValue.Caption := 'Value';
   // ----------------------------------------------
   //  
   fEdMax := TEdit(CreateControl(TEdit, fPanel, '',
                       156,66,70,20));
   fEdMax.Text := '100';
   fEdMax.OnChange := EdMaxChange;
   fLbMax := TLabel(CreateControl(TLabel, fPanel, '',
                       156,48,70,20));
   fLbMax.Caption := 'Max';
   // ----------------------------------------------
   //  
   fTrackBar := TTrackBar(CreateControl(TTrackBar, fPanel, '',
                           4, 88, 230, 24));
   fTrackBar.Min := -100;
   fTrackBar.Max := 100;
   fTrackBar.Position := 0;
   fTrackBar.OnChange := TrackBarChange;
   // ----------------------------------------------
   //   
   fChBoxNPr := TCheckBox(CreateControl(TCheckBox, fPanel, '',
                           12, 118, 170, 20));
   fChBoxNPr.Checked := True;                        
   fChBoxNPr.Caption := '    :';
   fEdNPr := TEdit(CreateControl(TEdit, fPanel, '',
                           180,118,40,20));
   fEdNPr.Text := '10';
   // ----------------------------------------------
   //    
   Randomize;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.Free;
begin
  // ---------------
  fLbIndx.Free;
  fLbTitle.Free;
  fSTxtIndx.Free;
  fEdTitle.Free;
  // ---------------
  fLbMin.Free;
  fLbValue.Free;
  fLbMax.Free;
  fEdMin.Free;
  fSTxtValue.Free;
  fEdMax.Free;
  // ---------------
  fTrackBar.Free;
  // ---------------
  fChBoxNPr.Free;
  fEdNPr.Free;
  // ---------------
  fPanel.Free;
  // ---------------
  inherited Free;
end;

// ================================================================
//       
// ================================================================
// ----------------------------------------------------------------
//    
procedure TSensor.EdMinChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMin, Value)
  then fTrackBar.Min := Value;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.EdMaxChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMax, Value)
  then fTrackBar.Max := Value;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.TrackBarChange(Sender: TObject);
begin
  fSTxtValue.Caption := IntToStr(fTrackBar.Position);
end;

// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
//    (    )
procedure TSensor.SetIndx(Indx : integer);
begin
  fSTxtIndx.Tag := Indx;
  fSTxtIndx.Caption := IntToStr(Indx);
end;
// ----------------------------------------------------------------
//    (    )
function TSensor.GetIndx() : integer;
begin
  Result := fSTxtIndx.Tag;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.SetTitle(Title : string);
begin
  fEdTitle.Text := Title;
end;
// ----------------------------------------------------------------
//   
function TSensor.GetTitle() : string;
begin
   Result := fEdTitle.Text;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.SetMin(Min : integer);
begin
  if Min < fTrackBar.Max
  then begin
     fEdMin.Enabled := False;
     fTrackBar.Min := Min;
     fTrackBar.Position := (fTrackBar.Max - fTrackBar.Min) div 2;
     fEdMin.Text := IntToStr(Min);
     fEdMin.Enabled := True;
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMin() : integer;
begin
   Result := fTrackBar.Min;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.SetMax(Max : integer);
begin
  if Max > fTrackBar.Min
  then begin
     fEdMax.Enabled := False;
     fTrackBar.Max := Max;
     fTrackBar.Position := (fTrackBar.Max - fTrackBar.Min) div 2;
     fEdMax.Text := IntToStr(Max);
     fEdMax.Enabled := True;
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMax() : integer;
begin
   Result := fTrackBar.Max;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetValue() : integer;
var Value : integer;
begin
   Result := fTrackBar.Position;
   if fChBoxNPr.Checked
   then begin
     if TryEditToInt(fEdNPr, Value)
     then Result := Result + Random(Abs(Round(Result * Value / 100)));
   end;
end;
// ================================================================
//   
// ================================================================
end.

